/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.stoneholm.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import net.thegrimsey.stoneholm.Stoneholm;
import net.thegrimsey.stoneholm.structures.UnderGroundVillageStructure;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneholmGenerator {
    static final Logger LOGGER = LogManager.getLogger();

    public static Optional<class_6622<class_3812>> generate(class_6834.class_6835<class_3812> inContext, PieceFactory pieceFactory, class_2338 pos) {
        int size = Stoneholm.CONFIG.VILLAGE_SIZE;
        if (size <= 0) {
            return Optional.empty();
        }
        class_5455 registryManager = inContext.comp_314();
        class_2378 registry = registryManager.method_30530(class_2378.field_25917);
        class_3785 structurePool = (class_3785)registry.method_10223(UnderGroundVillageStructure.START_POOL);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12663(inContext.comp_308(), inContext.comp_309().field_9181, inContext.comp_309().field_9180);
        class_3784 startingElement = structurePool.method_16631((Random)chunkRandom);
        if (startingElement == class_3777.field_16663) {
            return Optional.empty();
        }
        class_2794 chunkGenerator = inContext.comp_306();
        class_3485 structureManager = inContext.comp_313();
        class_5539 heightLimitView = inContext.comp_311();
        Predicate biomePredicate = inContext.comp_312();
        class_3195.method_28664();
        class_2470 blockRotation = class_2470.method_16548((Random)chunkRandom);
        class_3790 poolStructurePiece = pieceFactory.create(structureManager, startingElement, pos, startingElement.method_19308(), blockRotation, startingElement.method_16628(structureManager, pos, blockRotation));
        class_3341 pieceBoundingBox = poolStructurePiece.method_14935();
        int centerX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int centerZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int y = pos.method_10264() + chunkGenerator.method_20402(centerX, centerZ, class_2902.class_2903.field_13194, heightLimitView);
        if (!biomePredicate.test(chunkGenerator.method_16359(class_5742.method_33100((int)centerX), class_5742.method_33100((int)y), class_5742.method_33100((int)centerZ)))) {
            return Optional.empty();
        }
        int yOffset = pieceBoundingBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, y - yOffset, 0);
        return Optional.of((structurePiecesCollector, context) -> {
            ArrayList list = Lists.newArrayList((Object[])new class_3790[]{poolStructurePiece});
            class_238 box = new class_238((double)(centerX - 80), (double)(y - 80), (double)(centerZ - 80), (double)(centerX + 80 + 1), (double)(y + 80 + 1), (double)(centerZ + 80 + 1));
            StoneholmStructurePoolGenerator structurePoolGenerator = new StoneholmStructurePoolGenerator((class_2378<class_3785>)registry, size, pieceFactory, chunkGenerator, structureManager, list, (Random)chunkRandom);
            structurePoolGenerator.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, (MutableObject<class_265>)new MutableObject((Object)class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)pieceBoundingBox)), (class_247)class_247.field_16886)), 0, null));
            while (!structurePoolGenerator.structurePieces.isEmpty()) {
                StoneholmShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
                structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, shapedPoolStructurePiece.sourceBlockPos, heightLimitView);
            }
            list.forEach(arg_0 -> ((class_6626)structurePiecesCollector).method_35462(arg_0));
        });
    }

    public static interface PieceFactory {
        public class_3790 create(class_3485 var1, class_3784 var2, class_2338 var3, int var4, class_2470 var5, class_3341 var6);
    }

    static final class StoneholmStructurePoolGenerator {
        final class_2378<class_3785> registry;
        final int maxSize;
        final PieceFactory pieceFactory;
        final class_2794 chunkGenerator;
        final class_3485 structureManager;
        final List<? super class_3790> children;
        final Random random;
        final Deque<StoneholmShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();
        final class_3785 fallback_down;
        final class_3785 fallback_side;
        final class_3785 end_cap;
        static final HashSet<class_2960> terrainCheckIgnoredPools = new HashSet<class_2960>(Arrays.asList(new class_2960("stoneholm", "bee"), new class_2960("stoneholm", "deco_blocks"), new class_2960("stoneholm", "deco_coverings"), new class_2960("stoneholm", "deco_wallpapers"), new class_2960("stoneholm", "iron_golem"), new class_2960("stoneholm", "villagers"), new class_2960("stoneholm", "armor_stands")));

        StoneholmStructurePoolGenerator(class_2378<class_3785> registry, int maxSize, PieceFactory pieceFactory, class_2794 chunkGenerator, class_3485 structureManager, List<? super class_3790> children, Random random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.children = children;
            this.random = random;
            this.fallback_down = (class_3785)registry.method_10223(new class_2960("stoneholm", "fallback_down_pool"));
            this.fallback_side = (class_3785)registry.method_10223(new class_2960("stoneholm", "fallback_side_pool"));
            this.end_cap = (class_3785)registry.method_10223(new class_2960("stoneholm", "end"));
        }

        void generatePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize, class_2338 sourceStructureBlockPos, class_5539 world) {
            class_3784 structurePoolElement = piece.method_16644();
            class_2338 sourcePos = piece.method_16648();
            class_2470 sourceRotation = piece.method_16888();
            MutableObject<class_265> mutableObject = new MutableObject<class_265>();
            class_3341 sourceBoundingBox = piece.method_14935();
            int boundsMinY = sourceBoundingBox.method_35416();
            class_2338 sourceBlock = sourcePos.method_10081((class_2382)(sourceStructureBlockPos == null ? class_2338.field_10980 : sourceStructureBlockPos));
            for (class_3499.class_3501 structureBlock : structurePoolElement.method_16627(this.structureManager, sourcePos, sourceRotation, this.random)) {
                boolean placed;
                class_3784 iteratedStructureElement;
                MutableObject<class_265> structureShape;
                if (sourceBlock.equals((Object)structureBlock.field_15597)) continue;
                class_2350 structureBlockFaceDirection = class_3748.method_26378((class_2680)structureBlock.field_15596);
                class_2338 structureBlockPosition = structureBlock.field_15597;
                class_2338 structureBlockAimPosition = structureBlockPosition.method_10093(structureBlockFaceDirection);
                class_2960 structureBlockTargetPoolId = new class_2960(structureBlock.field_15595.method_10558("pool"));
                Optional targetPool = this.registry.method_17966(structureBlockTargetPoolId);
                if (targetPool.isEmpty() || ((class_3785)targetPool.get()).method_16632() == 0 && !Objects.equals(structureBlockTargetPoolId, class_5468.field_26254.method_29177())) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)structureBlockTargetPoolId);
                    continue;
                }
                boolean ignoredPool = terrainCheckIgnoredPools.contains(structureBlockTargetPoolId);
                class_2960 terminatorPoolId = ((class_3785)targetPool.get()).method_16634();
                Optional terminatorPool = this.registry.method_17966(terminatorPoolId);
                if (terminatorPool.isEmpty() || ((class_3785)terminatorPool.get()).method_16632() == 0 && !Objects.equals(terminatorPoolId, class_5468.field_26254.method_29177())) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)terminatorPoolId);
                    continue;
                }
                boolean containsPosition = sourceBoundingBox.method_14662((class_2382)structureBlockAimPosition);
                if (containsPosition) {
                    structureShape = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)sourceBoundingBox)));
                    }
                } else {
                    structureShape = pieceShape;
                }
                ArrayList possibleElementsToSpawn = Lists.newArrayList();
                if (currentSize < this.maxSize) {
                    possibleElementsToSpawn.addAll(((class_3785)targetPool.get()).method_16633(this.random));
                }
                possibleElementsToSpawn.addAll(((class_3785)terminatorPool.get()).method_16633(this.random));
                Iterator iterator = possibleElementsToSpawn.iterator();
                while (iterator.hasNext() && (iteratedStructureElement = (class_3784)iterator.next()) != class_3777.field_16663 && !(placed = this.tryPlacePiece(piece, currentSize, world, boundsMinY, structureBlock, structureShape, structureBlockFaceDirection, structureBlockPosition, structureBlockAimPosition, iteratedStructureElement, currentSize >= 2 && !ignoredPool))) {
                }
            }
        }

        boolean tryPlacePiece(class_3790 piece, int currentSize, class_5539 world, int boundsMinY, class_3499.class_3501 structureBlock, MutableObject<class_265> structureShape, class_2350 structureBlockFaceDirection, class_2338 structureBlockPosition, class_2338 structureBlockAimPosition, class_3784 element, boolean doTerrainCheck) {
            int j = structureBlockPosition.method_10264() - boundsMinY;
            int t = boundsMinY + j;
            int pieceGroundLevelDelta = piece.method_16646();
            for (class_2470 randomizedRotation : class_2470.method_16547((Random)this.random)) {
                List structureBlocksInStructure = element.method_16627(this.structureManager, class_2338.field_10980, randomizedRotation, this.random);
                for (class_3499.class_3501 structureBlockInfo : structureBlocksInStructure) {
                    if (!class_3748.method_16546((class_3499.class_3501)structureBlock, (class_3499.class_3501)structureBlockInfo)) continue;
                    class_2338 structureBlockPos = structureBlockInfo.field_15597;
                    class_2338 structureBlockAimDelta = structureBlockAimPosition.method_10059((class_2382)structureBlockPos);
                    class_3341 iteratedStructureBoundingBox = element.method_16628(this.structureManager, structureBlockAimDelta, randomizedRotation);
                    int structureBlockY = structureBlockPos.method_10264();
                    int o = j - structureBlockY + class_3748.method_26378((class_2680)structureBlock.field_15596).method_10164();
                    int adjustedMinY = boundsMinY + o;
                    int pieceYOffset = adjustedMinY - iteratedStructureBoundingBox.method_35416();
                    class_3341 offsetBoundingBox = iteratedStructureBoundingBox.method_19311(0, pieceYOffset, 0);
                    if (class_259.method_1074((class_265)((class_265)structureShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)offsetBoundingBox).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                    if (doTerrainCheck && structureBlockFaceDirection != class_2350.field_11033) {
                        boolean maxXminZ;
                        boolean minXmaxZ;
                        int maxYBuffer = 3;
                        int maxY = offsetBoundingBox.method_35419() + maxYBuffer;
                        boolean minCorner = maxY > this.chunkGenerator.method_20402(offsetBoundingBox.method_35415(), offsetBoundingBox.method_35417(), class_2902.class_2903.field_13194, world);
                        boolean maxCorner = maxY > this.chunkGenerator.method_20402(offsetBoundingBox.method_35418(), offsetBoundingBox.method_35420(), class_2902.class_2903.field_13194, world);
                        int overTerrainCorners = (minCorner ? 1 : 0) + ((minXmaxZ = maxY > this.chunkGenerator.method_20402(offsetBoundingBox.method_35415(), offsetBoundingBox.method_35420(), class_2902.class_2903.field_13194, world)) ? 1 : 0) + (maxCorner ? 1 : 0) + ((maxXminZ = maxY > this.chunkGenerator.method_20402(offsetBoundingBox.method_35418(), offsetBoundingBox.method_35417(), class_2902.class_2903.field_13194, world)) ? 1 : 0);
                        if (overTerrainCorners > 1) {
                            element = this.end_cap.method_16631(this.random);
                            if (overTerrainCorners > 2) {
                                element = currentSize + 2 > this.maxSize ? this.end_cap.method_16631(this.random) : this.fallback_side.method_16631(this.random);
                            }
                            return this.tryPlacePiece(piece, currentSize, boundsMinY, structureBlock, structureShape, structureBlockPosition, structureBlockAimPosition, element);
                        }
                    }
                    class_3785.class_3786 iteratedProjection = element.method_16624();
                    class_2338 offsetBlockPos = structureBlockAimDelta.method_10069(0, pieceYOffset, 0);
                    structureShape.setValue((Object)class_259.method_1082((class_265)((class_265)structureShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)offsetBoundingBox)), (class_247)class_247.field_16886));
                    int s = pieceGroundLevelDelta - o;
                    class_3790 poolStructurePiece = this.pieceFactory.create(this.structureManager, element, offsetBlockPos, s, randomizedRotation, offsetBoundingBox);
                    piece.method_16647(new class_3780(structureBlockAimPosition.method_10263(), t - j + pieceGroundLevelDelta, structureBlockAimPosition.method_10260(), o, iteratedProjection));
                    poolStructurePiece.method_16647(new class_3780(structureBlockPosition.method_10263(), t - structureBlockY + s, structureBlockPosition.method_10260(), -o, class_3785.class_3786.field_16687));
                    this.children.add((class_3790)poolStructurePiece);
                    if (currentSize + 1 <= this.maxSize) {
                        this.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, structureShape, currentSize + 1, structureBlockPos));
                    }
                    return true;
                }
            }
            return false;
        }

        boolean tryPlacePiece(class_3790 piece, int currentSize, int boundsMinY, class_3499.class_3501 structureBlock, MutableObject<class_265> structureShape, class_2338 structureBlockPosition, class_2338 structureBlockAimPosition, class_3784 element) {
            int j = structureBlockPosition.method_10264() - boundsMinY;
            int t = boundsMinY + j;
            int pieceGroundLevelDelta = piece.method_16646();
            for (class_2470 randomizedRotation : class_2470.method_16547((Random)this.random)) {
                List structureBlocksInStructure = element.method_16627(this.structureManager, class_2338.field_10980, randomizedRotation, this.random);
                for (class_3499.class_3501 structureBlockInfo : structureBlocksInStructure) {
                    if (class_3748.method_16546((class_3499.class_3501)structureBlock, (class_3499.class_3501)structureBlockInfo)) continue;
                    class_2338 structureBlockPos = structureBlockInfo.field_15597;
                    class_2338 structureBlockAimDelta = structureBlockAimPosition.method_10059((class_2382)structureBlockPos);
                    class_3341 iteratedStructureBoundingBox = element.method_16628(this.structureManager, structureBlockAimDelta, randomizedRotation);
                    int structureBlockY = structureBlockPos.method_10264();
                    int o = j - structureBlockY + class_3748.method_26378((class_2680)structureBlock.field_15596).method_10164();
                    int adjustedMinY = boundsMinY + o;
                    int pieceYOffset = adjustedMinY - iteratedStructureBoundingBox.method_35416();
                    class_3341 offsetBoundingBox = iteratedStructureBoundingBox.method_19311(0, pieceYOffset, 0);
                    if (class_259.method_1074((class_265)((class_265)structureShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)offsetBoundingBox).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                    class_3785.class_3786 iteratedProjection = element.method_16624();
                    class_2338 offsetBlockPos = structureBlockAimDelta.method_10069(0, pieceYOffset, 0);
                    structureShape.setValue((Object)class_259.method_1082((class_265)((class_265)structureShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)offsetBoundingBox)), (class_247)class_247.field_16886));
                    int s = pieceGroundLevelDelta - o;
                    class_3790 poolStructurePiece = this.pieceFactory.create(this.structureManager, element, offsetBlockPos, s, randomizedRotation, offsetBoundingBox);
                    piece.method_16647(new class_3780(structureBlockAimPosition.method_10263(), t - j + pieceGroundLevelDelta, structureBlockAimPosition.method_10260(), o, iteratedProjection));
                    poolStructurePiece.method_16647(new class_3780(structureBlockPosition.method_10263(), t - structureBlockY + s, structureBlockPosition.method_10260(), -o, class_3785.class_3786.field_16687));
                    this.children.add((class_3790)poolStructurePiece);
                    if (currentSize + 1 <= this.maxSize) {
                        this.structurePieces.addLast(new StoneholmShapedPoolStructurePiece(poolStructurePiece, structureShape, currentSize + 1, structureBlockPos));
                    }
                    return true;
                }
            }
            return false;
        }
    }

    record StoneholmShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize, class_2338 sourceBlockPos) {
    }
}

